--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()							returns time of day in seconds
--Return.Day()							returns day of month
--Return.Month()						returns month as number
--Return.Year()							returns year as number
--Return.Mission()						returns campaign mission number
--Return.CampFlag(flag-n)				returns value of campaign flag
--Return.AirUnitActive("UnitName")		returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")		returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")		returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")		returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")		returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")		returns percentage of alive sub elements in target
--Return.GroupHidden("GroupName")		returns group hidden status
--Return.GroupProbability("GroupName")	returns group spawn probability value between 0 and 1

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.SetCampFlag(flag-n, boolean/number)
--Action.AddCampFlag(flag-n, number)
--Action.AddImage("filname.jpg")
--Action.CampaignEnd("win"/"draw"/"loss")
--Action.TargetActive("TargetName", boolean)
--Action.AirUnitActive("UnitName", boolean)
--Action.AirUnitBase("UnitName", "BaseName")
--Action.AirUnitPlayer("UnitName", boolean)
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)
--Action.AirUnitRepair()
--Action.AddGroundTargetIntel("sideName")
--Action.GroupHidden("GroupName", boolean)
--Action.GroupProbability("GroupName", number 0-1)

--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("This large-scale combat exercise aims to simulate an offensive air campaign conducted by US Air Force units based at Nellis AFB against current Soviet, East German, Polish and Czechoslovak air and ground threats in and around the Nellis Air Force Range. You are assigned to the adversary group acting as the Warsaw Pact forces during this exercise. From now on it is your duty to think and act like a communist pilot.")',
			[2] = 'Action.Text("Our units involved in this campaign include the Soviet 76th Fighter Regiment, the Polish 34th Fighter Regiment and the East German 8th Fighter Regiment, equipped with MiG-21bis fighters. They are supported by the Czechoslovak 17th Fighter Regiment flying the MiG-15bis. The aircraft are directed by a network of 4 early warning radar stations distributed throughout our sector. The defenses of our ground forces include Kub, Osa and Neva surface-to-air missiles as well as various anti-aircraft artillery. Our objective for this exercise is to defend our ground forces and installations from air attack until the enemy has exhausted all of his offensive air power.")',
			[3] = 'Action.Text("You are assigned as pilot to the Polish 34. Fighter Regiment currently based at Tonopah AFB. Before hostilities are initiated, the 34.PLM is tasked to relocate to the unit’s wartime operating base at Groom Lake. ")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Win 1"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("64 FWS") + Return.AirUnitAlive("65 FWS") < 2 and Return.AirUnitAlive("34 TFS") + Return.AirUnitAlive("4 TFS") < 2',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("After sustaining heavy losses at the hands of our fighters and surface-to-air missiles, the US Air Force is unable to continue combat operations. The umpires have called an end to this exercise and declared victory for the Warsaw Pact forces. The fighting has been grim, with losses that would be hard to accept in a real war. But ultimately we have prevailed under the most difficult conditions. This success belongs to the pilots and ground crews. Congratulations!")',
		},
	},
	["Campaign End Win 2"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 30',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("For several days, there has been a substantial lack of air activities, with the US Air Force apparently unable to launch any more decisive offensive operations. The umpires have decided to call off the exercise and declare victory for the Warsaw Pact forces. The fighting has been grim, with losses that would be hard to accept in a real war. But ultimately we have prevailed under the most difficult conditions. This success belongs to the pilots and ground crews. Congratulations!")',
		},
	},
	["Campaign End Loss 1"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./76.IAP") + Return.AirUnitAlive("2./76.IAP") < 2 and Return.AirUnitAlive("1./34.PLM") + Return.AirUnitAlive("2./34.PLM") < 2',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("After sustaining heavy losses in combat, the Soviet 76. Fighter Regiment and the Polish 34. Fighter Regiment have run out of aircraft. Both regiments were forced to stand down and cease all operations. Unable to oppose the enemy in the air any longer, our ground units are now at the mercy of enemy of enemy air strikes. The umpires have called an end to this exercise and declared the complete defeat of the Warsaw Pact forces. The fighting has been hard and we gave our best, but ultimately it was just not enough.")',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 16',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("The US Air Force managed to destroy all of its assigned ground targets. Despite having still some operational aircraft left, the Warsaw Pact air forces have been unable to prevent the complete destruction of the assets it was supposed to defend. The umpires have called an end to this exercise and declared the defeat of the Warsaw Pact forces. The fighting has been hard and we gave our best, but ultimately it was just not enough.")',
		},
	},
	
	
	----- UNIT RELOCATION -----
--[[	["1./34.PLM Relocate To Groom Lake"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 2',
		action = {
			[1] = 'Action.AirUnitActive("64 FWS", true)',
			[2] = 'Action.AirUnitActive("65 FWS", true)',
			[3] = 'Action.AirUnitActive("34 TFS", true)',
			[4] = 'Action.AirUnitActive("4 TFS", true)',
			[5] = 'Action.AirUnitActive("23 BS/Det", true)',
			[6] = 'Action.AirUnitActive("23 BS", true)',
			[7] = 'Action.AirUnitBase("1./34.PLM", "Groom Lake AFB")',
			[8] = 'Action.Text("Welcome to Groom Lake, your new home for the next time. The Polish 34.PLM will conduct all its combat operations from this base. Groom Lake is well defended by 3 Neva surface-air missile battalions, which should allow for undisturbed operations at the airbase.")',
			[9] = 'Action.TargetActive("Nellis AFB OCA Strike", true)',
			[10] = 'Action.TargetActive("AWACS Sweep", true)',
		},
	},--]]
	["Player Switch To 76. IAP"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./34.PLM") + Return.AirUnitAlive("2./34.PLM") < 2',
		action = {
			[1] = 'Action.AirUnitPlayer("1./34.PLM", false)',
			[2] = 'Action.AirUnitPlayer("1./76.IAP", true)',
			[3] = 'Action.Text("The Polish 34. Fighter Regiment has exhausted its aircraft strength and is no longer able to support combat operations. You and the remaining pilots of the 34.PLM have been transferred to Tonopah AFB to join the Soviet 76.IAP to continue combat with this regiment.")',
		},
	},
	
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	["Reinforcemenets 64 FWS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("65 FWS", "64 FWS", 18)',
	},
	["Reinforcemenets 34 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("4 TFS", "34 TFS", 18)',
	},
	["Reinforcemenets 23 BS/Det"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("23 BS", "23 BS/Det", 5)',
	},
	["Reinforcemenets 1./76.IAP"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("2./76.IAP", "1./76.IAP", 12)',
	},
	["Reinforcemenets I./JG-8"] = {
		active = true,
		condition = 'Return.TargetAlive("303 Creech AFB") > 0',
		action = 'Action.AirUnitReinforce("III./JG-8", "I./JG-8", 12)',
	},
	["Reinforcemenets II./JG-8"] = {
		active = true,
		condition = 'Return.TargetAlive("304 Beatty Airport") > 0',
		action = 'Action.AirUnitReinforce("III./JG-8", "II./JG-8", 3)',
	},
	["Reinforcemenets 1./34.PLM"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("2./34.PLM", "1./34.PLM", 12)',
	},
	["Reinforcemenets 1./17.SLP"] = {
		active = true,
		condition = 'Return.TargetAlive("305 Lincoln County Airport") > 0',
		action = 'Action.AirUnitReinforce("2./17.SLP", "1./17.SLP", 6)',
	},
	
	
	----- AVIATION UNIT STATUS -----
	["76.IAP Alive 60%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./76.IAP") + Return.AirUnitAlive("2./76.IAP") < 22',
		action = 'Action.Text("Total aircraft strength of the Soviet 76.IAP has fallen below 60%.")',
	},
	["76.IAP Alive 30%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./76.IAP") + Return.AirUnitAlive("2./76.IAP") < 11',
		action = 'Action.Text("Total aircraft strength of the Soviet 76.IAP has fallen below 30%. If losses continue at the present rate, the combat capability of the regiment is in jeopardy.")',
	},
	["76.IAP Alive 15%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./76.IAP") + Return.AirUnitAlive("2./76.IAP") < 6',
		action = 'Action.Text("Total aircraft strength of the Soviet 76.IAP has fallen below 15%. The number of available airframes is critically low. The regiment is short of losing all remaining combat capability.")',
	},
	["34.PLM Alive 60%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./34.PLM") + Return.AirUnitAlive("2./34.PLM") < 15',
		action = 'Action.Text("Total aircraft strength of the Polish 34.PLM has fallen below 60%.")',
	},
	["34.PLM Alive 30%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./34.PLM") + Return.AirUnitAlive("2./34.PLM") < 8',
		action = 'Action.Text("Total aircraft strength of the Polish 34.PLM has fallen below 30%. If losses continue at the present rate, the combat capability of the regiment is in jeopardy.")',
	},
	["34.PLM Alive 15%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("1./34.PLM") + Return.AirUnitAlive("2./34.PLM") < 4',
		action = 'Action.Text("Total aircraft strength of the Polish 34.PLM has fallen below 15%. The number of available airframes is critically low. The regiment is short of losing all remaining combat capability.")',
	},
	["963 AWCS Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("963 AWCS") == 1',
		action = 'Action.Text("The enemy has lost one of his valuable E-3A Sentry AWACS aircraft. This loss will put considerable gaps in his ability to support his air operations with early warning and control.")',
	},
	["963 AWCS Alive 0%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("963 AWCS") == 0',
		action = {
			[1] = 'Action.Text("The enemy has lost his second E-3A Sentry AWACS aircraft. He is now unable to support his air operations with early warning and control, which considerably complicates his efforts to protect strike packages from our interceptors. Life just got a little bit easier for us.")',
			[2] = 'Action.TargetActive("AWACS Sweep", false)',
		}
	},
	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	
	----- AIRBASE STRIKES -----
	["Beatty Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("304 Beatty Airport") == 0',
		action = {
			[1] = 'db_airbases["Beatty"].inactive = true',
		}
	},
	["Beatty Airport Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("304 Beatty Airport") == 0',
		action = {
			[1] = 'Action.Text("After the facilities at Beatty Airport have been hit by air strikes and were completely destroyed, air operations at this base have come to a complete stop. The East German II./JG-8 is no longer able to participate in combat operations.")',
		}
	},
	["Lincoln County Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("305 Lincoln County Airport") == 0',
		action = {
			[1] = 'db_airbases["Lincoln"].inactive = true',
		}
	},
	["Lincoln County Airport Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("305 Lincoln County Airport") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at Lincoln County Airport has been destroyed completely by enemy air strikes. Flight operations by the Czechoslovak 1./17.SLP have ceased completely and are unlikely to resume.")',
		}
	},
	["Creech AFB Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("303 Creech AFB") == 0',
		action = {
			[1] = 'db_airbases["Creech AFB"].inactive = true',
		}
	},
	["Creech AFB Disable Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("303 Creech AFB") == 0',
		action = {
			[1] = 'Action.Text("Creech AFB has been hit hard by enemy air strikes. The ammunition and fuel storage depots have been completely destroyed. Due to the lack of supplies, the East German I./JG-8 is unable to continue combat operations.")',
			[2] = 'Action.TargetActive("Sweep Frenchman Flat", false)',
		}
	},
	
	
	----- CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("101 EWR Site (Callsign 1)") == 0 and Return.TargetAlive("102 EWR Site (Callsign 2)") == 0 and Return.TargetAlive("104 EWR Site (Callsign 3)") == 0',
		action = {
			[1] = 'Action.TargetActive("CAP Station Dogbone Lake", true)',
			[2] = 'Action.TargetActive("CAP Station Alamo", true)',
			[3] = 'Action.TargetActive("CAP Station Mercury", true)',
			[4] = 'Action.TargetActive("CAP Station Rachel", true)',
			[5] = 'Action.TargetActive("CAP Station EC South", true)',
			[6] = 'Action.Text("The destruction of the three most important radar early warning sites in the area of operations has seriously degraded our ability to timely launch interceptors. One radar site remains far to the northwest, in fact we belief it is out of range for the enemy to attack. But its radar range is insufficient to cover anything but the rear area around Tonopah AFB. To compensate, standing Combat Air Patrols will be set up in the likely enemy avenues of approach.")',
		},
	},
	["CAP Station C-1 Activate"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("206 S-125 Neva Site C-1") < 50 and Return.TargetAlive("207 S-125 Neva Site C-2") < 50',
		action = {
			[1] = 'Action.TargetActive("CAP Station Charlie", true)',
			[2] = 'Action.Text("The disabling of the S-125 Neva battalions C-1 and C-2 has exposed some important ground assets to air attack. A Combat Air Patrol station will be set up in the area to close the gap in the air defense coverage.")',
		},
	},
	["CAP Station B-2 Activate"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("204 2K12 Kub Site B-1") < 50 and Return.TargetAlive("205 2K12 Kub Site B-2") < 50',
		action = {
			[1] = 'Action.TargetActive("CAP Station Bravo", true)',
			[2] = 'Action.Text("The disabling of the 2K12 Kub batteries B-1 and B-2 has exposed the units of TF Venera to air attack. A Combat Air Patrol station will be set up to provide TF Venera with the necessary air defense protection.")',
		},
	},
	["CAP Station A-3 Activate"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("201 2K12 Kub Site A-1") < 50 and Return.TargetAlive("202 2K12 Kub Site A-2") < 50 and Return.TargetAlive("203 2K12 Kub Site A-3") < 50',
		action = {
			[1] = 'Action.TargetActive("CAP Station Alpha", true)',
			[2] = 'Action.Text("The disabling of the 2K12 Kub batteries A-1, A-2 and A-3 has exposed the 8th Army to air attack. A Combat Air Patrol station will be set up over the 8th Army deployment area to reestablish its air defense screen.")',
		},
	},
	
	
	----- NEWSPAPER -----
	["Newspaper Creech AFB Hit"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("303 Creech AFB") < 100',
		action = {
			[1] = 'Action.AddImage("Newspaper_Creech.jpg")',
		}
	},
	["Newspaper Occupation Gov Hit"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("804 Lincoln County Occupation Gov HQ") < 100',
		action = {
			[1] = 'Action.AddImage("Newspaper_Court.jpg")',
		}
	},
	["Newspaper Military Police Hit"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("803 Lincoln County Military Police HQ") < 100',
		action = {
			[1] = 'Action.AddImage("Newspaper_Police.jpg")',
		}
	},
}